#
# **** GNUPLOT CONTROL FILE ****   for data contained in file <TSNR.out>
#
# TSNR Analysis of a MASH 2+1 SWC Sigma-Delta Modulator 
# (tool                ) tsnr - frequency domain analysis - (JOINED File 1/2, "tmp2.out") 
# (compiler version    ) NAPA V4.02 for Win64 
# (source file         ) TSNR.tmp 
# (random seed         ) 780428190 
# (normalization       ) O2 / 1 
# (bandwidth           ) 10.0000  Hz .. 16.0000 kHz, through a psophometric filter 
# (samples             ) 65536 
# (sampling frequency  ) 2.00000 MHz 
# (frequency resolution) 30.5176  Hz 
# (window              ) Blackman Harris 7-Term 
# (window resolution   ) 488.281  Hz 
# 
# Tue Jun 18 13:13:00 2019 by Yves Leduc 
#
print("\n")
print(" *****  About to plot data from file \"TSNR.out\"  *****\n")
print("\n")
#
#
myfile = "TSNR.out"
#
pause 1
#
# Set-up for an INDEXED 2D plot
#
short = " TSNR Analysis of a MASH 2+1 SWC Sigma-Delta Modulator \n Yves Leduc "
long  = " TSNR Analysis of a MASH 2+1 SWC Sigma-Delta Modulator \n Tue Jun 18 13:13:00 2019 by Yves Leduc "
#
# Select here your title (short or long):
set title long
#
set grid
set datafile missing "?"
if (!exists("MY_FLAG_PLOT_2D")) {
  set style data lines
  MY_FLAG_PLOT_2D = 1
}
set xlabel "sig RMS [dB]"
set ylabel ""
set zlabel "packet"
set format "%.1s%c"
set macro
#
# Use 'w0 = nnn' to set the default line width, and/or 'w1 = nnn ...' to modify individual line widths 
#
if (!exists("w0")) { w0 =  0 }
if (!exists("w1")) { w1 = w0 }
if (!exists("w2")) { w2 = w0 }
if (!exists("w3")) { w3 = w0 }
#
MYPLOT1  = "myfile  i  0  u  3: 5 lw w1  t 'tsnr [dB] - # 1'"
MYPLOT2  = "myfile  i  1  u  3: 5 lw w2  t 'tsnr [dB] - # 2'"
MYPLOT3  = "myfile  i  2  u  3: 5 lw w3  t 'tsnr [dB] - # 3'"
#
#
# Tips: use macro @MYPLOTn to plot more sophisticated graphs, like
#   ->  plot @MYPLOT1 smooth bezier
#   ->  plot @MYPLOT1 smooth bezier, @MYPLOT3  w p
#   ->  ...
#
#
plot  @MYPLOT1, @MYPLOT2, @MYPLOT3
#
#
# end
